<?php  
include('connection.php');
session_start();

// Check for admin login
if (!isset($_SESSION['admin_login'])) {
    ?>
    <script>
    window.location="login.php";
    </script>
    <?php
}

// Get filters from the POST request
$class = isset($_POST['class']) ? $_POST['class'] : '';
$exam_type = isset($_POST['exam_type']) ? $_POST['exam_type'] : '';
$year = isset($_POST['year']) ? $_POST['year'] : '';

// Define all the subjects and their respective tables
$subjects = [
    'Mathematics' => 'mathematics',
    'English' => 'english',
    'Kiswahili' => 'kiswahili',
    'Physics' => 'physics',
    'Chemistry' => 'chemistry',
    'Biology' => 'biology',
    'Geography' => 'geography',
    'History' => 'history',
    'Civics' => 'civics' ,
    'French' => 'french',
    'Literature' => 'literature'
];

// Prepare headers for CSV download
header('Content-Type: text/csv');
header('Content-Disposition: attachment;filename="student_results.csv"');

// Open output stream to start writing CSV
$output = fopen('php://output', 'w');

// Write the headers, including full_name and gender
fputcsv($output, [
    'REGISTRATION NUMBER', 'NAME', 'GENDER', 
    'MATHS', 'ENGL', 'KISW', 'PHY', 'CHEM', 'BIO', 
    'GEOG', 'HIST', 'CIV','FREN', 'LIT', 'TOTAL', 'AVG', 'PTS', 'DIV'
]);

// Fetch the student registration numbers from any one subject (e.g., mathematics)
$regNumbersQuery = "SELECT DISTINCT registration_number FROM mathematics WHERE 1=1";

$bindParams = [];
if (!empty($class)) {
    $regNumbersQuery .= " AND class = ?";
    $bindParams[] = $class;
}
if (!empty($exam_type)) {
    $regNumbersQuery .= " AND exam_type = ?";
    $bindParams[] = $exam_type;
}
if (!empty($year)) {
    $regNumbersQuery .= " AND year = ?";
    $bindParams[] = $year;
}

$stmt = $con->prepare($regNumbersQuery);
if (count($bindParams)) {
    $stmt->bind_param(str_repeat('s', count($bindParams)), ...$bindParams);
}

$stmt->execute();
$regNumbersResult = $stmt->get_result();

if ($regNumbersResult->num_rows > 0) {
    while ($row = $regNumbersResult->fetch_assoc()) {
        $registration_number = $row['registration_number'];
        $studentData = ['registration_number' => $registration_number];
        $studentData['class'] = $class;
        $studentData['exam_type'] = $exam_type;
        $studentData['year'] = $year;

        // Fetch full_name and gender from the students table
        $studentInfoQuery = "SELECT full_name, gender FROM students WHERE registration_number = ?";
        $stmt = $con->prepare($studentInfoQuery);
        $stmt->bind_param('s', $registration_number);
        $stmt->execute();
        $studentInfoResult = $stmt->get_result();

        if ($studentInfoResult->num_rows > 0) {
            $studentInfo = $studentInfoResult->fetch_assoc();
            $studentData['full_name'] = $studentInfo['full_name'];
            $studentData['gender'] = ($studentInfo['gender'] == 'Male') ? 'M' : 'F';
        } else {
            $studentData['full_name'] = 'N/A';
            $studentData['gender'] = 'N/A';
        }

        // Fetch scores for each subject for the current student
        $totalScore = 0;
        $scoreCount = 0;
        $scores = [];

        foreach ($subjects as $subject_name => $table_name) {
            $subjectQuery = "SELECT score FROM $table_name WHERE registration_number = ? AND class = ? AND exam_type = ? AND year = ?";
            $stmt = $con->prepare($subjectQuery);
            $stmt->bind_param('ssss', $registration_number, $class, $exam_type, $year);
            $stmt->execute();
            $result = $stmt->get_result();
            $score = ($result->num_rows > 0) ? $result->fetch_assoc()['score'] : 'N/A'; // Handle no score case

            $studentData[$subject_name] = $score;

            if (is_numeric($score)) {
                $totalScore += $score;
                $scores[] = $score;
                $scoreCount++;
            }
        }

        // Calculate total, average, points, and division
        $averageScore = $scoreCount > 0 ? round($totalScore / $scoreCount) : 0;
        $points = calculatePoints($scores); // Use the same calculatePoints function as before
        $division = count($scores) >= 7 ? calculateDivision($points) : 'N/A'; // Division logic

        // Add total, average, points, and division to student data
        $studentData['total_score'] = $totalScore;
        $studentData['average_score'] = $averageScore;
        $studentData['points'] = $points;
        $studentData['division'] = $division;

        // Write student data to CSV, including full_name and gender
        fputcsv($output, [
            $studentData['registration_number'],
            $studentData['full_name'],
            $studentData['gender'],
            $studentData['Mathematics'],
            $studentData['English'],
            $studentData['Kiswahili'],
            $studentData['Physics'],
            $studentData['Chemistry'],
            $studentData['Biology'],
            $studentData['Geography'],
            $studentData['History'],
            $studentData['Civics'],
            $studentData['French'],
            $studentData['Literature'],
            $studentData['total_score'],
            $studentData['average_score'],
            $studentData['points'],
            $studentData['division']
        ]);
    }
}

// Close the output stream
fclose($output);


// Function to calculate points based on the highest seven scores
function calculatePoints($scores) {
    $gradePoints = [
        'A' => 1, 'B' => 2, 'C' => 3, 'D' => 4, 'F' => 5
    ];

    // Sort scores in descending order
    rsort($scores);

    // Take only the highest seven scores
    $topScores = array_slice($scores, 0, 7);

    // Calculate points based on the top seven scores
    $points = 0;
    foreach ($topScores as $score) {
        if ($score >= 75) $points += $gradePoints['A'];
        elseif ($score >= 65) $points += $gradePoints['B'];
        elseif ($score >= 45) $points += $gradePoints['C'];
        elseif ($score >= 30) $points += $gradePoints['D'];
        else $points += $gradePoints['F'];
    }
    return $points;
}

// Function to calculate division based on points
function calculateDivision($points) {
    if ($points >= 7 && $points <= 17) return 'I';
    if ($points >= 18 && $points <= 21) return 'II';
    if ($points >= 22 && $points <= 25) return 'III';
    if ($points >= 26 && $points <= 33) return 'IV';
    return '0';
}
?>
